﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace RacetrackSimulator
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            this.components = null;
            this.MyRandom = new Random();
            this.dogs = new Greyhound[4];
            this.guys = new Guy[3];
            this.InitializeComponent();
            Guy guy = new Guy();
            guy.Cash = 50;
            guy.Name = "Janek";
            guy.MyBet = new Bet();
            guy.MyLabel = this.joebetlabel;
            guy.MyRadioButton = this.joeradioButton;
            this.guys[0] = guy;
            Guy guy2 = new Guy();
            guy2.Cash = 0x4b;
            guy2.Name = "Bartek";
            guy2.MyBet = new Bet();
            guy2.MyLabel = this.bobbetlabel;
            guy2.MyRadioButton = this.bobradioButton;
            this.guys[1] = guy2;
            Guy guy3 = new Guy();
            guy3.Cash = 0x2d;
            guy3.Name = "Arek";
            guy3.MyBet = new Bet();
            guy3.MyLabel = this.albetlabel;
            guy3.MyRadioButton = this.alradioButton;
            this.guys[2] = guy3;
            for (int i = 0; i < this.guys.Length; i++)
            {
                this.guys[i].MyBet.Amount = 0;
                this.guys[i].MyBet.Dog = 0;
                this.guys[i].MyBet.Bettor = this.guys[i];
                this.guys[i].UpdateLabels();
            }
            int index = 0;
            for (int j = 0; index < 4; j += 60)
            {
                this.dogs[index] = new Greyhound();
                this.dogs[index].RacetrackLength = this.racetrackpictureBox.Width;
                this.dogs[index].StartingPosition = this.racetrackpictureBox.Location.X;
                this.dogs[index].MyRandom = new Random();
                this.dogs[index].Location = 0x19 + j;
                this.dogs[index].distance = this.MyRandom.Next(5);
                index++;
            }
            this.dogs[0].MyPictureBox = this.dog1pictureBox;
            this.dogs[1].MyPictureBox = this.dog2pictureBox;
            this.dogs[2].MyPictureBox = this.dog3pictureBox;
            this.dogs[3].MyPictureBox = this.dog4pictureBox;
            this.raceButton.Enabled = false;
            this.minimumBetlabel.Text = "Minimalny zakład: " + ((int)this.betnumericUpDown.Value) + " zł";
        }

        private void alradioButton_CheckedChanged(object sender, EventArgs e)
        {
            this.betlabel.Text = "Arek";
        }

        private void betsbutton_Click(object sender, EventArgs e)
        {
            bool flag = false;
            if (this.joeradioButton.Checked)
            {
                flag = this.guys[0].PlaceBet((int)this.betnumericUpDown.Value, (int)this.dognumericUpDown.Value);
            }
            if (this.bobradioButton.Checked)
            {
                flag = this.guys[1].PlaceBet((int)this.betnumericUpDown.Value, (int)this.dognumericUpDown.Value);
            }
            if (this.alradioButton.Checked)
            {
                flag = this.guys[2].PlaceBet((int)this.betnumericUpDown.Value, (int)this.dognumericUpDown.Value);
            }
            if (flag)
            {
                MessageBox.Show("Zakład przyjęto", "Informacje o zakładzie");
                this.raceButton.Enabled = true;
            }
            else
            {
                MessageBox.Show("Nie przyjęto zakładu", "Informacje o zakładzie");
            }
        }

        private void bobradioButton_CheckedChanged(object sender, EventArgs e)
        {
            this.betlabel.Text = "Bartek";
        }

        private void joeradioButton_CheckedChanged(object sender, EventArgs e)
        {
            this.betlabel.Text = "Janek";
        }

        private void raceButton_Click(object sender, EventArgs e)
        {
            int num2;
            this.raceButton.Enabled = false;
            this.betsbutton.Enabled = false;
            bool flag = false;
            int num = 0;
            while (!flag)
            {
                num2 = 0;
                while (num2 < 4)
                {
                    if (this.dogs[num2].Run())
                    {
                        flag = true;
                        num = num2;
                    }
                    num2++;
                }
            }
            MessageBox.Show("Mamy zwycięzcę - pies numer " + (num + 1) + "!", "Koniec wyścigu");
            for (int i = 0; i < this.guys.Length; i++)
            {
                if ((this.guys[i].MyBet.Amount >= 5) && (this.guys[i].Cash > 0))
                {
                    this.guys[i].Collect(num + 1);
                }
                this.guys[i].ClearBet();
            }
            for (num2 = 0; num2 < 4; num2++)
            {
                this.dogs[num2].TakeStartingPosition();
                this.dogs[num2].distance = this.MyRandom.Next(5);
            }
            this.betnumericUpDown.Value = 5M;
            this.dognumericUpDown.Value = 1M;
            this.joeradioButton.Checked = true;
            this.betsbutton.Enabled = true;
            this.raceButton.Enabled = false;
            if (((this.guys[0].Cash < this.betnumericUpDown.Value) && (this.guys[1].Cash < this.betnumericUpDown.Value)) && (this.guys[2].Cash < this.betnumericUpDown.Value))
            {
                MessageBox.Show("Przykro mi - wszyscy są spłukani i nie ma kto stawiać!!!", "Koniec gry!!!");
                this.betsbutton.Enabled = false;
            }
        }


    }
}
